-- ADD a Primary Key
ALTER TABLE CustNew
ADD PRIMARY KEY (Cust_id)

--Select the name of the Primary Key field
SELECT name
FROM sys.key_constraints
WHERE type = 'PK' AND OBJECT_NAME(parent_object_id) = N'CustNew';
GO

--Alter table and DROP CONSTRAINT Primary Key
DECLARE @sql NVARCHAR(4000);
SELECT @sql = 'alter table ' + QUOTENAME(N'CustNew') + ' drop constraint ' +
	QUOTENAME(name)
FROM 
	sys.key_constraints
WHERE 
	type = 'PK' AND OBJECT_NAME(parent_object_id) = N'CustNew';
-- sp_executesql 
EXEC sp_executesql @sql;

--Re-select the name of the Primary Key field
SELECT name
FROM sys.key_constraints
WHERE type = 'PK' AND OBJECT_NAME(parent_object_id) = N'CustNew';
GO